/*
 * Decompiled with CFR 0.152.
 */
package org.sinytra.connector.transformer;

import cpw.mods.modlauncher.api.LambdaExceptionUtils;
import java.io.File;
import java.io.IOException;
import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Stream;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.MethodInsnNode;
import org.objectweb.asm.tree.MethodNode;
import org.sinytra.adapter.patch.api.MethodContext;
import org.sinytra.adapter.patch.api.Patch;
import org.sinytra.adapter.patch.api.PatchContext;
import org.sinytra.adapter.patch.api.PatchEnvironment;
import org.sinytra.connector.transformer.FieldToMethodTransformer;
import org.sinytra.connector.transformer.patch.ClassNodeTransformer;
import org.sinytra.connector.transformer.patch.RedirectAccessorToMethod;
import reloc.net.minecraftforge.srgutils.IMappingFile;

public class AccessorRedirectTransformer
implements ClassNodeTransformer.ClassProcessor {
    private static final String PREFIX = "connector$redirect$";
    public static final List<? extends Patch> PATCHES = FieldToMethodTransformer.REPLACEMENTS.entrySet().stream().flatMap(entry -> ((Map)entry.getValue()).values().stream().map(s -> ((Patch.InterfacePatchBuilder)((Patch.InterfacePatchBuilder)((Patch.InterfacePatchBuilder)Patch.interfaceBuilder().targetClass(((String)entry.getKey()).replace('.', '/'))).targetField((String)s).transform(new RedirectAccessorToMethod((String)s))).transform((classNode, methodNode, methodContext, patchContext) -> {
        methodNode.name = PREFIX + methodNode.name;
        return Patch.Result.APPLY;
    })).build())).toList();
    private final IMappingFile mappings;
    private final Map<String, Map<String, String>> methodRenames = new HashMap<String, Map<String, String>>();

    public AccessorRedirectTransformer(IMappingFile mappings) {
        this.mappings = mappings;
    }

    public void analyze(File input, Set<String> mixinPackages, PatchEnvironment environment) throws IOException {
        List accessorAnalysisPatches = FieldToMethodTransformer.REPLACEMENTS.entrySet().stream().flatMap(entry -> ((Map)entry.getValue()).keySet().stream().map(s -> ((Patch.InterfacePatchBuilder)((Patch.InterfacePatchBuilder)Patch.interfaceBuilder().targetClass(this.mappings.remapClass(((String)entry.getKey()).replace('.', '/')))).targetField((String)s).transform(this::analyzeAccessor)).build())).toList();
        try (FileSystem fs = FileSystems.newFileSystem(input.toPath(), Map.of());){
            for (String pkg : mixinPackages) {
                Path packageRoot = fs.getPath(pkg, new String[0]);
                if (Files.notExists(packageRoot, new LinkOption[0])) continue;
                Stream<Path> stream = Files.walk(packageRoot, new FileVisitOption[0]);
                try {
                    stream.filter(path -> path.getFileName().toString().endsWith(".class")).forEach(LambdaExceptionUtils.rethrowConsumer(path -> this.analyzeClass((Path)path, accessorAnalysisPatches, environment)));
                }
                finally {
                    if (stream == null) continue;
                    stream.close();
                }
            }
        }
    }

    @Override
    public Patch.Result process(ClassNode node) {
        boolean applied = false;
        for (MethodNode method : node.methods) {
            for (AbstractInsnNode insn : method.instructions) {
                String newName;
                if (!(insn instanceof MethodInsnNode)) continue;
                MethodInsnNode minsn = (MethodInsnNode)insn;
                Map<String, String> renames = this.methodRenames.get(minsn.owner);
                if (renames == null || (newName = renames.get(minsn.name + minsn.desc)) == null) continue;
                minsn.name = newName;
                applied = true;
            }
        }
        return applied ? Patch.Result.APPLY : Patch.Result.PASS;
    }

    private void analyzeClass(Path path, List<? extends Patch> accessorAnalysisPatches, PatchEnvironment environment) throws IOException {
        byte[] bytes = Files.readAllBytes(path);
        ClassReader reader = new ClassReader(bytes);
        ClassNode node = new ClassNode();
        reader.accept((ClassVisitor)node, 1);
        for (Patch patch : accessorAnalysisPatches) {
            patch.apply(node, environment);
        }
    }

    private Patch.Result analyzeAccessor(ClassNode classNode, MethodNode methodNode, MethodContext methodContext, PatchContext context) {
        this.methodRenames.computeIfAbsent(classNode.name, s -> new HashMap()).put(methodNode.name + methodNode.desc, PREFIX + methodNode.name);
        return Patch.Result.PASS;
    }
}

